/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include "LogThread.h"
#include "Log.h"
#include <time.h>
#include <sys/time.h>

using namespace std;

LogThread::LogThread(int threadNumber, unsigned int messageCycles)
    :   m_threadNo(threadNumber),
        m_threadStartTime(0),
        m_cyclesRequired(messageCycles),
        m_cyclesDone(0),
        m_timeFromLastCycle(0),
        m_lastCycleTime(0),
        m_cumulativeTime(0),
        m_timeInLoop(0)
{
}

LogThread::~LogThread()
{
}

void* LogThread::printLogging()
{
    unsigned int timeAtEnd = getCurrentTime();
    unsigned int loopStartTime = timeAtEnd;
    unsigned int loopEndTime = 0;
    m_lastCycleTime = timeAtEnd;
    m_threadStartTime = timeAtEnd;

    for (m_cyclesDone = 0; m_cyclesDone < m_cyclesRequired; ++m_cyclesDone)
    {
        LOG_INFO("Log Thread",
                 "No. " << m_threadNo <<
                 " at time: " << getCurrentTime() <<
                 " cycle no.: " << m_cyclesDone);
        LOG_DEBUG("Log Thread",
                 "No. " << m_threadNo <<
                 " at time: " << getCurrentTime() <<
                 " cycle no.: " << m_cyclesDone);
        LOG_ERROR("Log Thread",
                 "No. " << m_threadNo <<
                 " at time: " << getCurrentTime() <<
                 " cycle no.: " << m_cyclesDone);
        LOG_WARNING("Log Thread",
                    "No. " << m_threadNo <<
                    " at time: " << getCurrentTime() <<
                    " cycle no.: " << m_cyclesDone);


        timeAtEnd = getCurrentTime();
        m_timeFromLastCycle = timeAtEnd - m_lastCycleTime;
        m_cumulativeTime = m_cumulativeTime + m_timeFromLastCycle;
        m_lastCycleTime = timeAtEnd;
    }

    m_timeInLoop = getCurrentTime() - loopStartTime;

    LOG_INFO("Log Thread",
             "No. " << m_threadNo <<
             " cumulative time: " << m_cumulativeTime <<
             " cycle done.: " << m_cyclesDone <<
             " time in loop: " << m_timeInLoop);

    pthread_exit(0);
}

void*
LogThread::thread_start(void* arg)
{
    reinterpret_cast<LogThread*>(arg)->printLogging();
    return NULL;
}

unsigned int LogThread::getCurrentTime()
{
    struct timeval tv;
    gettimeofday(&tv, NULL);
    return tv.tv_sec * 1000 + tv.tv_usec / 1000;
}
